<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
<#assign deCodeNameCamel = srfcaseformat(de.codeName,'l_u2lC')?cap_first>
<#comment>实体是否配置预置属性</#comment>
<#assign hasDEPrefield=false>
<#if de.getPSDEFieldByPDT('ORGID',true)?? || de.getPSDEFieldByPDT('ORGSECTORID',true)??  || de.getPSDEFieldByPDT('CREATEMAN',true)?? >
    <#assign hasDEPrefield=true>
</#if>
<#if de.getStorageMode()==1 || de.getStorageMode()==2 ||de.getStorageMode()==4||de.getStorageMode()==0>
<#comment>判断是否有1：N的主关系，用于填充外键值文本、附加数据</#comment>
<#assign hasMinorPSDERs=0>
<#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
    <#list item.getMinorPSDERs() as MinorPSDER>
        <#if MinorPSDER.getDERType() =='DER1N'  && (MinorPSDER.getMajorPSDataEntity().getStorageMode()==1||MinorPSDER.getMajorPSDataEntity().getStorageMode()==2||MinorPSDER.getMajorPSDataEntity().getStorageMode()==4) >
            <#list de.getAllPSDEFields() as defield>
                <#if defield.getPSDER1N?? && defield.getPSDER1N()?? && defield.getPSDER1N().name==MinorPSDER.name && (((defield.getDataType())!'')!='PICKUP')>
                    <#assign hasMinorPSDERs=hasMinorPSDERs+1>
                    <#break>
                </#if>
            </#list>
        </#if>
    </#list>
</#if>
<#comment>判断是否有1：N的主关系属性映射(sum.avg.max.min.count..)</#comment>
<#assign hasPSDERsMapping=false>
<#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
    <#list item.getMinorPSDERs() as MinorPSDER>
        <#if MinorPSDER.getPSDER1NDEFieldMaps?? && MinorPSDER.getPSDER1NDEFieldMaps()?? && MinorPSDER.getDERType() =='DER1N'  && (MinorPSDER.getMajorPSDataEntity().getStorageMode()==1||MinorPSDER.getMajorPSDataEntity().getStorageMode()==2||MinorPSDER.getMajorPSDataEntity().getStorageMode()==4) >
            <#list MinorPSDER.getPSDER1NDEFieldMaps() as derField>
                <#if derField.getMapType()=="COUNT" || derField.getMapType()=="SUM"|| derField.getMapType()=="AVG" || derField.getMapType()=="MAX" || derField.getMapType()=="MIN">
                    <#assign hasPSDERsMapping=true>
                    <#break>
                </#if>
            </#list>
        </#if>
    </#list>
</#if>
<#comment>判断当前实体是否为索引子实体</#comment>
<#assign isIndexSubDE=false>
<#comment>判断当前实体是否为逻辑继承子实体</#comment>
<#assign isLogicInheritDE=false>
<#if de.getMinorPSDERs()??>
<#list de.getMinorPSDERs() as MinorPSDER>
    <#if MinorPSDER.getDERType()?? && MinorPSDER.getMajorPSDataEntity()??>
        <#comment>继承关系、索引关系 (包含分组属性)</#comment>
        <#if MinorPSDER.getDERType()=="DERINHERIT" || (MinorPSDER.getDERType()=="DERINDEX" && MinorPSDER.getMajorPSDataEntity().getVirtualMode()!=3 && MinorPSDER.getMajorPSDataEntity().getIndexTypePSDEField()??)>
            <#assign isIndexSubDE=true>
            <#assign indexPSDER=MinorPSDER>
            <#assign majorIndexDE=indexPSDER.getMajorPSDataEntity()>
            <#assign majorIndexDECodeName=indexPSDER.getMajorPSDataEntity().codeName>
            <#assign majorIndexDECodeNameCamel = srfcaseformat(majorIndexDECodeName,'l_u2lC')?cap_first>
            <#if MinorPSDER.getDERType()=="DERINHERIT" && MinorPSDER.isLogicInherit()>
                <#assign isLogicInheritDE=true>
            </#if>
            <#break>
        </#if>
    </#if>
</#list>
</#if>
<#assign hasDEImport=false>
<#comment>实体数据导入</#comment>
<#if de.getAllPSDEDataImports?? && de.getAllPSDEDataImports()??>
    <#list de.getAllPSDEDataImports() as deImport>
        <#assign hasDEImport=true>
        <#break>
    </#list>
</#if>
package ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
<#if pub.isEnableGlobalTransaction?? && pub.isEnableGlobalTransaction()?? && pub.isEnableGlobalTransaction()==true>
import io.seata.spring.annotation.GlobalTransactional;
</#if>
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()};
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.filter.${de.getCodeName()}SearchContext;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.service.I${de.getCodeName()}Service;

import ${pub.getPKGCodeName()}.util.helper.CachedBeanCopier;
import ${pub.getPKGCodeName()}.util.helper.DEFieldCacheMap;

<#comment>SQL存储-Mybatis</#comment>
<#if de.getStorageMode()==1>

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.mapper.${item.getCodeName()}Mapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[${item.getLogicName()}] 服务对象接口实现
 */
@Slf4j
@Service("${item.getCodeName()}ServiceImpl")
public class ${item.getCodeName()}ServiceImpl extends ServiceImpl<${de.getCodeName()}Mapper, ${de.getCodeName()}> implements I${de.getCodeName()}Service {

    <#assign keyfield=de.getKeyPSDEField()>

    <#comment>引入关联依赖-从关系</#comment>
    <#if de.getMajorPSDERs()??>
        <#list de.getMajorPSDERs() as der>
            <#if der.getDERType() =='DER1N' && (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2||der.getMinorPSDataEntity().getStorageMode()==4)>
                <#if !P.exists('DER1N',der.getMinorPSDataEntity().getCodeName())>
                    <#if der.getMinorPSDataEntity().getCodeName()==de.codeName>

    protected ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service = this;
                    <#else>
    @Autowired
    @Lazy
    protected ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                    </#if>
                </#if>
            </#if>
        </#list>
    </#if>
    <#comment>引入关联依赖-主关系</#comment>
    <#if de.getMinorPSDERs()??>
        <#list de.getMinorPSDERs() as der>
            <#if der.getDERType() =='DER1N' && (der.getMajorPSDataEntity().getStorageMode()==1||der.getMajorPSDataEntity().getStorageMode()==2||der.getMajorPSDataEntity().getStorageMode()==4)>
                <#if !P.exists('DER1N',der.getMajorPSDataEntity().getCodeName())>
                    <#if der.getMajorPSDataEntity().getCodeName()==de.codeName>

    protected ${pub.getPKGCodeName()}.core.${der.getMajorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMajorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMajorPSDataEntity().getCodeName(),'l_u2lC')}Service = this;
                    <#else>
    @Autowired
    @Lazy
    protected ${pub.getPKGCodeName()}.core.${der.getMajorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMajorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMajorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                    </#if>
                </#if>
            </#if>
        </#list>
    </#if>
    <#comment>引入处理逻辑</#comment>
    <#if de.getAllPSDEActions()??>
        <#list de.getAllPSDEActions() as deAction>
            <#comment>实体行为调用处理逻辑</#comment>
            <#if deAction.getActionType() =='DELOGIC' >
            <#assign deLogic=deAction.getPSDELogic()>
                <@importDELogic deLogic />
            </#if>
            <#comment>实体行为附加逻辑</#comment>
            <#if deAction.getPSDEActionLogics()??>
                <#list deAction.getPSDEActionLogics() as deActionLogic>
                    <#if deActionLogic.isInternalLogic()>
                    <#assign deLogic=deActionLogic.getPSDELogic()>
                    <@importDELogic deLogic />
                    </#if>
                </#list>
            </#if>
        </#list>
    </#if>

    protected int batchSize = 500;

    <#comment>输出实体行为</#comment>
    <#if item.getAllPSDEActions()??>
        <#list item.getAllPSDEActions() as deaction>
            <#if deaction.isEnableBackend()>
                <#if deaction.getRender()??>
    ${deaction.getRender().code}
                <#else>
                    <#if (deaction.getActionType()=='USERCUSTOM')>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "usercustom"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //自定义代码
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getActionType()=='DELOGIC'>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "delogic"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        ${deaction.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
         return et ;
    }

                    <#elseif deaction.getCodeName()?lower_case == 'get'>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} get(${srfjavatype(keyfield.stdDataType)} key) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "get"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@buildEntityParam deaction/>
        <@addGetActionBoforeLogic deaction/>
        ${item.getCodeName()} et = getById(key);
        if(et==null){
            et=new ${item.getCodeName()}();
            et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(key);
        }
        else{
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
                        <#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
            et.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.selectBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key));
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        }
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "createbatch">
                    <#elseif deaction.getCodeName()?lower_case == "updatebatch">
                    <#elseif deaction.getCodeName()?lower_case == "removebatch">
                    <#elseif deaction.getCodeName()?lower_case == "savebatch">
                    <#elseif deaction.getCodeName()?lower_case == "create">
    @Override
    <@transactionalAnno deaction/>
    public boolean create(${item.getCodeName()} et) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "create"/>
        <#if hasMinorPSDERs gt 0>
        fillParentData(et);
        </#if>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>同步创建索引主实体、继承主实体数据：继承子实体属性来源与父，先保存父，再保存子，最后get一次获取父数据返回</#comment>
        <#if isIndexSubDE>
        createIndexMajorEntityData(et);
        </#if>
        <#if isLogicInheritDE>
        if(!update(et,(Wrapper) et.getUpdateWrapper(true).eq("${keyfield.name?lower_case}",et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}())))
        <#else>
        if(!this.retBool(this.baseMapper.insert(et)))
        </#if>
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#if hasPSDERsMapping>
        updateParentData(et);
        </#if>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    @Override
    public void createBatch(List<${item.getCodeName()}> list) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "createBatch"/>
        <#if hasMinorPSDERs gt 0>
        list.forEach(item->fillParentData(item));
        </#if>
        <#comment>联合主键，走SaveOrUpdateBatch，防止因主键冲突导致后续数据无法保存</#comment>
        <#if item.getUnionKeyValuePSDEFields()??>
        this.saveOrUpdateBatch(list,batchSize);
        <#else>
        this.saveBatch(list,batchSize);
        </#if>
        <#comment>批量更新父数据（实体关系属性映射）</#comment>
        <#if hasPSDERsMapping>
        updateParentDataBatch(list);
        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "update">
    @Override
    <@transactionalAnno deaction/>
    public boolean update(${item.getCodeName()} et) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "update"/>
        <#if hasMinorPSDERs gt 0>
        fillParentData(et);
        </#if>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>同步更新索引主实体、继承主实体数据：继承子实体属性来源与父，先保存父，再保存子，最后get一次获取父数据返回</#comment>
        <#if isIndexSubDE>
        ${srfcaseformat(majorIndexDECodeName,'l_u2lC')}Service.update(${de.codeName?lower_case}InheritMapping.to${majorIndexDECodeNameCamel}(et));
        </#if>
        <#if de.getKeyPSDEField()??>
        if(!update(et,(Wrapper) et.getUpdateWrapper(true).eq("${keyfield.name?lower_case}",et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}())))
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#if hasPSDERsMapping>
        updateParentData(et);
        </#if>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
        <#else>
        throw new RuntimeException("请检查[${de.getLogicName()}]实体是否存在主键属性");
        </#if>
    }

    @Override
    public void updateBatch(List<${item.getCodeName()}> list) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "updateBatch"/>
        <#if hasMinorPSDERs gt 0>
        list.forEach(item->fillParentData(item));
        </#if>
        updateBatchById(list,batchSize);
        <#comment>批量更新父数据（实体关系属性映射）</#comment>
        <#if hasPSDERsMapping>
        updateParentDataBatch(list);
        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "save">
    @Override
    <@transactionalAnno deaction/>
    public boolean save(${item.getCodeName()} et) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "save"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        if(!saveOrUpdate(et))
            return false;
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    @Override
    <@transactionalAnno deaction/>
    public boolean saveOrUpdate(${item.getCodeName()} et) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "saveOrUpdate"/>
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    public boolean saveBatch(Collection<${item.getCodeName()}> list) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "saveBatch"/>
        <#if hasMinorPSDERs gt 0>
        list.forEach(item->fillParentData(item));
        </#if>
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    public void saveBatch(List<${item.getCodeName()}> list) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "saveBatch"/>
        <#if hasMinorPSDERs gt 0>
        list.forEach(item->fillParentData(item));
        </#if>
        saveOrUpdateBatch(list,batchSize);
    }

                    <#elseif deaction.getCodeName()?lower_case == "remove">
    @Override
    <@transactionalAnno deaction/>
    public boolean remove(${srfjavatype(keyfield.stdDataType)} key) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "remove"/>
        <#comment>附加数据逻辑-操作前，通过key构造entity传入逻辑中</#comment>
        <@buildEntityParam deaction/>
        <@addBoforeLogic deaction/>
        <#if hasPSDERsMapping>
        ${item.getCodeName()} entity=this.get(key);
        </#if>
                                <#if de.getMajorPSDERs()??>
                                    <#list de.getMajorPSDERs() as der>
                                        <#if der.getDERType() =='DER1N' && der.isNestedRS() && der.getMinorPSDataEntity()?? &&  (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2||der.getMinorPSDataEntity().getStorageMode()==4) >
                                        <#assign MajorDerField = der.getPSPickupDEField()>
                                        <#assign minorKeyField = der.getMinorPSDataEntity().getKeyPSDEField()>
        ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service.removeBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key) ;
                                        </#if>
                                    </#list>
                                </#if>
        <#comment>同步清除索引主实体数据</#comment>
        <#if isIndexSubDE>
        ${srfcaseformat(majorIndexDECodeName,'l_u2lC')}Service.remove(key);
        </#if>
        boolean result=removeById(key);
        <#if hasPSDERsMapping>
        updateParentData(entity);
        </#if>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return result ;
    }

    @Override
    public void removeBatch(Collection<${srfjavatype(keyfield.stdDataType)}> idList) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "removeBatch"/>
        <#if hasPSDERsMapping>
        List<${item.getCodeName()}> entities= baseMapper.selectBatchIds(idList);
        </#if>
        removeByIds(idList);
        <#comment>批量更新父数据（实体关系属性映射）</#comment>
        <#if hasPSDERsMapping>
        updateParentDataBatch(entities);
        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "getdraft">
    @Override
    public ${item.getCodeName()} getDraft(${item.getCodeName()} et) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "getdraft"/>
        <#if hasMinorPSDERs gt 0>
        fillParentData(et);
        </#if>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "checkkey">
    @Override
    public boolean checkKey(${item.getCodeName()} et) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "checkkey"/>
        return (!ObjectUtils.isEmpty(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()))&&(!Objects.isNull(this.getById(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}())));
    }
                    <#comment>用户扩展新建、更新</#comment>
                    <#elseif deaction.getActionType()== "USERCREATE" || deaction.getActionType()== "USERUPDATE">
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
                        <#comment>输出测试行为</#comment>
                        <@outputTestAction deaction "userex"/>
                        <#comment>附加数据逻辑-操作前</#comment>
                        <@addBoforeLogic deaction/>
                        <#comment>附加实体行为参数</#comment>
                        <@addDEActionParam deaction/>
                        <#comment>附加数据逻辑-操作后</#comment>
                        <@addAfterLogic deaction/>
        return et;
    }
                    <#else>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>输出测试行为</#comment>
        <@outputTestAction deaction "other"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        //自定义代码
        return et;
    }

                    </#if>
    <#comment>输出测试实体行为</#comment>
    <@outputTestActionDetail deaction/>
                </#if>
            </#if>
        </#list>
    </#if>

    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
	@Override
    public List<${item.getCodeName()}> selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        return baseMapper.selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
    }

    @Override
    public void removeBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        this.remove(new QueryWrapper<${item.getCodeName()}>().eq("${MajorField.getName()?lower_case}",${MajorkeyField.codeName?lower_case}));
    }

	                                <#assign nested=MinorPSDER.isNestedRS()>
                                    <#if nested == false && MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                                        <#list MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                            <#if api.isNested()>
                                                <#assign nested=true>
                                            </#if>
                                        </#list>
                                    </#if>
                                    <#if nested>
                                        <@autowiredProxyService/>
	@Override
    public void saveBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case},List<${item.getCodeName()}> list) {
        if(list==null)
            return;
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        List<${item.getCodeName()}> _update=new ArrayList<${item.getCodeName()}>();
        List<${item.getCodeName()}> _create=new ArrayList<${item.getCodeName()}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        for(${item.getCodeName()} sub:list) {
            sub.set${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
            if(ObjectUtils.isEmpty(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}()))
                sub.set${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})sub.getDefaultKey(true));
            if(delIds.contains(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}())) {
                delIds.remove(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            proxyService.updateBatch(_update);
        if(_create.size()>0)
            proxyService.createBatch(_create);
        if(delIds.size()>0)
            proxyService.removeBatch(delIds);
	}

                                    </#if>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>

    <#comment>输出数据查询</#comment>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
            <#if dedataset.getRender()??>
    ${dedataset.getRender().code}
            <#else>
    /**
     * 查询集合 ${dedataset.getLogicName()}
     */
    @Override
    public Page<<#if dedataset.isEnableGroup()>HashMap<#else>${item.getCodeName()}</#if>> search${dedataset.getCodeName()}(${item.getCodeName()}SearchContext context) {
            <#if item.isEnableSQLStorage() && item.getAllPSDEDBTables()??>
                <#--<#list item.getAllPSDEDBTables() as detable>-->
        <#if de.hasPSDEWF()==true>
        fillWFTaskContext(context);
        </#if>
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<<#if dedataset.isEnableGroup()>HashMap<#else>${item.getCodeName()}</#if>> pages=baseMapper.search${dedataset.getCodeName()}(context.getPages(),context,context.getSelectCond());
        return new PageImpl<<#if dedataset.isEnableGroup()>HashMap<#else>${item.getCodeName()}</#if>>(pages.getRecords(), context.getPageable(), pages.getTotal());
                <#--</#list>-->
            <#else>
        return null ;
            </#if>
    }

            </#if>
        </#list>
    </#if>

    <#comment>引入工作流FeignClient</#comment>
    <#if de.hasPSDEWF()==true>
    <#assign entityName=srfpluralize(item.getCodeName()?lower_case)>
    @Autowired
    private ${pub.getPKGCodeName()}.util.client.IBZWFFeignClient ibzwfFeignClient;

    /**
     * 查询工作流待办
     * @param context
     */
    private void fillWFTaskContext(${item.getCodeName()}SearchContext context){

        if(!StringUtils.isEmpty(context.getUserTaskId()) && !StringUtils.isEmpty(context.getProcessDefinitionKey())){
            List<String> businessKeys= ibzwfFeignClient.getbusinesskeysByUserId("${sys.getCodeName()?lower_case}", ${pub.getPKGCodeName()}.util.security.AuthenticationUser.getAuthenticationUser().getUserid(),"${entityName}",context.getProcessDefinitionKey(),context.getUserTaskId());
            if(businessKeys.size()>0){
                context.getSelectCond().in("${keyfield.name?lower_case}",businessKeys);
            }
            else{
                context.getSelectCond().apply("1<>1");
            }
        }
    }
    </#if>

    <#comment>为当前实体填充父数据（外键值文本、外键值附加数据）</#comment>
    <#if hasMinorPSDERs gt 0>
    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(${item.getCodeName()} et){
        <#list item.getMinorPSDERs() as MinorPSDER>
            <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N' && (MinorPSDER.getMajorPSDataEntity().getStorageMode()==1||MinorPSDER.getMajorPSDataEntity().getStorageMode()==2||MinorPSDER.getMajorPSDataEntity().getStorageMode()==4)>
                <#assign hasPickupData=false>
                <#list de.getAllPSDEFields() as defield>
                    <#if defield.getPSDER1N?? && defield.getPSDER1N()?? && defield.getPSDER1N().name==MinorPSDER.name && (((defield.getDataType())!'')!='PICKUP')>
                        <#assign hasPickupData=true>
                        <#break>
                    </#if>
                </#list>
                <#if hasPickupData==true && MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
                    <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
                    <#assign MajorEntityName=srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')>
                    <#assign MajorKeyFieldCodeName =srfcaseformat(MinorPSDER.getPSPickupDEField().codeName,'l_u2lC')?cap_first>
                    <#assign MajorEntityService=srfcaseformat(MinorPSDER.getMajorPSDataEntity().getCodeName(),'l_u2lC')+"Service">
        //实体关系[${MinorPSDER.name}]
        if(!ObjectUtils.isEmpty(et.get${MajorKeyFieldCodeName}())){
            ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntity.getCodeName()} ${MajorEntityName}=et.get${MajorEntityName?cap_first}();
            if(ObjectUtils.isEmpty(${MajorEntityName})){
                ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntity.getCodeName()} majorEntity=${MajorEntityService}.get(et.get${MajorKeyFieldCodeName}());
                et.set${MajorEntityName?cap_first}(majorEntity);
                ${MajorEntityName}=majorEntity;
            }
            <#comment>找出当前关系的外键值文本及附加数据字段</#comment>
            <#list de.getAllPSDEFields() as defield>
                <#if defield.getPSDER1N?? && defield.getPSDER1N()?? && defield.getPSDER1N().name==MinorPSDER.name && (((defield.getDataType())!'')!='PICKUP')>
                    <#assign minorFieldCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC')?cap_first >
                    <#assign majorFieldCodeName = srfcaseformat(defield.getRelatedPSDEField().getCodeName(),'l_u2lC')?cap_first >
            et.set${minorFieldCodeName}(${MajorEntityName}.get${majorFieldCodeName}());
                </#if>
            </#list>
        }
                </#if>
            </#if>
        </#list>
    }
    </#if>

    <#comment>更新父数据（实体关系属性映射）</#comment>
    <#if hasPSDERsMapping>
    /**
     * 更新父数据（实体关系属性映射）
     * @param et
     */
    private void updateParentData(${item.getCodeName()} et){
        <#list item.getMinorPSDERs() as MinorPSDER>
            <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N' && (MinorPSDER.getMajorPSDataEntity().getStorageMode()==1||MinorPSDER.getMajorPSDataEntity().getStorageMode()==2||MinorPSDER.getMajorPSDataEntity().getStorageMode()==4)>
                <#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
                    <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
                    <#assign MajorEntityName=srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')>
                    <#assign MajorKeyFieldName =MinorPSDER.getPSPickupDEField().name?lower_case>
                    <#assign MajorKeyFieldCodeName =srfcaseformat(MinorPSDER.getPSPickupDEField().codeName,'l_u2lC')?cap_first>
        //实体关系[${MinorPSDER.name}]
        if(!ObjectUtils.isEmpty(et.get${MajorKeyFieldCodeName}())){
            <#if MinorPSDER.getPSDER1NDEFieldMaps?? && MinorPSDER.getPSDER1NDEFieldMaps()??>
            ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntity.getCodeName()} ${MajorEntityName}=new ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntity.getCodeName()}();
                <#list MinorPSDER.getPSDER1NDEFieldMaps() as derField>
                    <#if derField.getMapType()=="COUNT" || derField.getMapType()=="SUM"|| derField.getMapType()=="AVG" || derField.getMapType()=="MAX" || derField.getMapType()=="MIN">
                        <#assign MajorEntityDEFieldCodeName=srfcaseformat(derField.getMajorPSDEField().codeName,'l_u2lC')>
                        <#if derField.getMapType()=="COUNT">
            ${MajorEntityName}.set("${MajorEntityDEFieldCodeName}",baseMapper.selectCount(new QueryWrapper().eq(true,"${MajorKeyFieldName}",et.get${MajorKeyFieldCodeName}())));
                        <#else>
                            <#assign MinorEntityDEFieldName=derField.getMinorPSDEField().name?lower_case>
                            <#if derField.getMapType()=="SUM">
                                <#assign derFieldType="sum("+MinorEntityDEFieldName+")">
                            <#elseif derField.getMapType()=="AVG">
                                <#assign derFieldType="avg("+MinorEntityDEFieldName+")">
                            <#elseif derField.getMapType()=="MAX">
                                <#assign derFieldType="max("+MinorEntityDEFieldName+")">
                            <#elseif derField.getMapType()=="MIN">
                                <#assign derFieldType="min("+MinorEntityDEFieldName+")">
                            </#if>
                            <#if derFieldType??>
            List<Object> objects_${derField_index} = baseMapper.selectObjs(new QueryWrapper().select("${derFieldType}").eq(true,"${MajorKeyFieldName}",et.get${MajorKeyFieldCodeName}()));
            if(!ObjectUtils.isEmpty(objects_${derField_index}) && objects_${derField_index}.size()>0){
                ${MajorEntityName}.set("${MajorEntityDEFieldCodeName}",objects_${derField_index}.get(0));
            }
                            </#if>
                        </#if>
                    </#if>
                </#list>
            ${MajorEntityName}.set("${MajorKeyFieldCodeName?lower_case}",et.get${MajorKeyFieldCodeName}());
            ${srfcaseformat(MinorPSDER.getMajorPSDataEntity().getCodeName(),'l_u2lC')}Service.update(${MajorEntityName});
            </#if>
        }
                </#if>
            </#if>
        </#list>
    }
    </#if>

    <#comment>批量更新父数据（实体关系属性映射）</#comment>
    <#if hasPSDERsMapping>
    /**
     * 批量更新父数据（实体关系属性映射）
     * @param entities
     */
    private void updateParentDataBatch(List <${item.getCodeName()}> entities){
        Map <Object,${item.getCodeName()}> map =new HashMap<>();
        if(entities.size()>0){
            for(${item.getCodeName()} entity: entities){
        <#list item.getMinorPSDERs() as MinorPSDER>
            <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N' && (MinorPSDER.getMajorPSDataEntity().getStorageMode()==1||MinorPSDER.getMajorPSDataEntity().getStorageMode()==2||MinorPSDER.getMajorPSDataEntity().getStorageMode()==4)>
                <#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
                    <#assign MajorKeyFieldCodeName =srfcaseformat(MinorPSDER.getPSPickupDEField().codeName,'l_u2lC')?cap_first>
                 //实体关系[${MinorPSDER.name}]
                 if(!ObjectUtils.isEmpty(entity.get${MajorKeyFieldCodeName}()) && !map.containsKey(entity.get${MajorKeyFieldCodeName}())){
                    map.put(entity.get${MajorKeyFieldCodeName}(),entity);
                 }
                </#if>
            </#if>
        </#list>
            }
            if(map.size()>0){
                map.values().forEach(entity -> updateParentData(entity));
            }
        }
    }
    </#if>

    <#comment>同步数据到索引主实体</#comment>
    <#if isIndexSubDE  && indexPSDER??>
    @Autowired
    ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().codeName?lower_case}.mapping.${de.codeName}InheritMapping ${de.codeName?lower_case}InheritMapping;
    <#if !P.exists('DER1N',majorIndexDECodeName)>
    @Autowired
    @Lazy
    protected ${pub.getPKGCodeName()}.core.${majorIndexDE.getPSSystemModule().getCodeName()?lower_case}.service.I${majorIndexDECodeName}Service ${srfcaseformat(majorIndexDECodeName,'l_u2lC')}Service;

    </#if>
    /**
     * 创建索引主实体数据
     * @param et
     */
    private void createIndexMajorEntityData(${de.codeName} et){
        if(ObjectUtils.isEmpty(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()))
            et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})et.getDefaultKey(true));
        ${pub.getPKGCodeName()}.core.${majorIndexDE.getPSSystemModule().getCodeName()?lower_case}.domain.${majorIndexDECodeName} ${majorIndexDECodeName?lower_case} =${de.codeName?lower_case}InheritMapping.to${majorIndexDECodeNameCamel}(et);
        <#if majorIndexDE.getIndexTypePSDEField()??>
        ${majorIndexDECodeName?lower_case}.set("${majorIndexDE.getIndexTypePSDEField().codeName?lower_case}","${indexPSDER.getTypeValue()}");
        </#if>
        ${srfcaseformat(majorIndexDECodeName,'l_u2lC')}Service.create(${majorIndexDECodeName?lower_case});
    }
    </#if>

    <#comment>输出自定义sql查询</#comment>
    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    <#if hasDEPrefield>
    @Override
    public List<${de.codeName}> get${deCodeNameCamel}ByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<${de.codeName}> get${deCodeNameCamel}ByEntities(List<${de.codeName}> entities) {
        List ids =new ArrayList();
        for(${de.codeName} entity : entities){
            Serializable id=entity.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0)
           return this.listByIds(ids);
        else
           return entities;
    }
    </#if>

    <#comment>实体数据导入</#comment>
    <@deImportData/>
}

<#comment>NOSQL存储</#comment>
<#elseif de.getStorageMode()==2>

import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().codeName?lower_case}.repository.${de.codeName}Repository;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import javax.annotation.Resource;
import com.mongodb.QueryBuilder;
/**
 * 实体[${item.getLogicName()}] 服务对象接口实现
 */
@Slf4j
@Service
public class ${item.getCodeName()}ServiceImpl implements I${de.getCodeName()}Service {

    @Autowired
    protected ${item.getCodeName()}Repository repository;
    <#assign keyfield=de.getKeyPSDEField()>

    <#comment>引入关联依赖</#comment>
    <#if de.getMajorPSDERs()??>
        <#list de.getMajorPSDERs() as der>
            <#if der.getDERType() =='DER1N' && (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2||der.getMinorPSDataEntity().getStorageMode()==4)>
                <#if !P.exists('DEMinorPSDataEntity',der.getMinorPSDataEntity().getCodeName())>
    @Autowired
    @Lazy
    protected ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                </#if>
            </#if>
        </#list>
    </#if>
    <#comment>引入处理逻辑</#comment>
    <#if de.getAllPSDEActions()??>
        <#list de.getAllPSDEActions() as deAction>
            <#comment>实体行为调用处理逻辑</#comment>
            <#if deAction.getActionType() =='DELOGIC' >
            <#assign deLogic=deAction.getPSDELogic()>
                <@importDELogic deLogic />
            </#if>
            <#comment>实体行为附加逻辑</#comment>
            <#if deAction.getPSDEActionLogics()??>
                <#list deAction.getPSDEActionLogics() as deActionLogic>
                    <#if deActionLogic.isInternalLogic()>
                    <#assign deLogic=deActionLogic.getPSDELogic()>
                    <@importDELogic deLogic />
                    </#if>
                </#list>
            </#if>
        </#list>
    </#if>

    <#comment>输出实体行为</#comment>
    <#if item.getAllPSDEActions()??>
        <#list item.getAllPSDEActions() as deaction>
            <#if deaction.isEnableBackend()>
                <#if deaction.getRender()??>
    ${deaction.getRender().code}
                <#else>
                    <#if (deaction.getActionType()=='USERCUSTOM')>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <@outputTestAction deaction "usercustom"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //自定义代码
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getActionType()=='DELOGIC'>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
         <@outputTestAction deaction "delogic"/>
         <#comment>附加数据逻辑-操作前</#comment>
         <@addBoforeLogic deaction/>
         ${deaction.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
         <#comment>附加数据逻辑-操作后</#comment>
         <@addAfterLogic deaction/>
         return et ;
    }

                    <#elseif deaction.getCodeName()?lower_case == 'get'>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} get(${srfjavatype(keyfield.stdDataType)} key) {
        <@outputTestAction deaction "get"/>
        <@buildEntityParam deaction/>
        <@addGetActionBoforeLogic deaction/>
        Optional<${item.getCodeName()}> result = repository.findById(key);
        if(!result.isPresent()){
            ${item.getCodeName()} et=new ${item.getCodeName()}();
            et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(key);
            <@addAfterLogic deaction/>
            return et;
        }
        else{
            ${item.getCodeName()} et=result.get();
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
            et.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.selectBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key));
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
            <@addAfterLogic deaction/>
            return et;
        }
    }

                    <#elseif deaction.getCodeName()?lower_case == "createbatch">
                    <#elseif deaction.getCodeName()?lower_case == "updatebatch">
                    <#elseif deaction.getCodeName()?lower_case == "removebatch">
                    <#elseif deaction.getCodeName()?lower_case == "savebatch">
                    <#elseif deaction.getCodeName()?lower_case == "create">
    @Override
    <@transactionalAnno deaction/>
    public boolean create(${item.getCodeName()} et) {
        <@outputTestAction deaction "create"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        repository.insert(et);
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true ;
    }

    @Override
    public void createBatch(List<${item.getCodeName()}> list) {
        <@outputTestAction deaction "createBatch"/>
        <#comment>联合主键，走SaveOrUpdateBatch，防止因主键冲突导致后续数据无法保存</#comment>
        <#if item.getUnionKeyValuePSDEFields()??>
        repository.saveAll(list);
        <#else>
        repository.insert(list);
        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "update">
    @Override
    <@transactionalAnno deaction/>
    public boolean update(${item.getCodeName()} et) {
        <@outputTestAction deaction "update"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#if de.getKeyPSDEField()??>
        repository.save(et);
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true ;
        <#else>
        throw new RuntimeException("请检查[${de.getLogicName()}]实体是否存在主键属性");
        </#if>
    }

    @Override
    public void updateBatch(List<${item.getCodeName()}> list) {
        <@outputTestAction deaction "updateBatch"/>
        repository.saveAll(list);
    }

                    <#elseif deaction.getCodeName()?lower_case == "save">
    @Override
    <@transactionalAnno deaction/>
    public boolean save(${item.getCodeName()} et) {
        <@outputTestAction deaction "save"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#if de.getKeyPSDEField()??>
        repository.save(et);
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true ;
        <#else>
        throw new RuntimeException("请检查[${de.getLogicName()}]实体是否存在主键属性");
        </#if>
    }


    @Override
    public void saveBatch(List<${item.getCodeName()}> list) {
        <@outputTestAction deaction "saveBatch"/>
        repository.saveAll(list);
    }

                    <#elseif deaction.getCodeName()?lower_case == "remove">
    @Override
    <@transactionalAnno deaction/>
    public boolean remove(${srfjavatype(keyfield.stdDataType)} key) {
        <@outputTestAction deaction "remove"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@buildEntityParam deaction/>
        <@addBoforeLogic deaction/>
                                <#if de.getMajorPSDERs()??>
                                    <#list de.getMajorPSDERs() as der>
                                        <#if der.getDERType() =='DER1N' && der.isNestedRS() && der.getMinorPSDataEntity()?? &&  (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2||der.getMinorPSDataEntity().getStorageMode()==4) >
                                        <#assign MajorDerField = der.getPSPickupDEField()>
                                        <#assign minorKeyField = der.getMinorPSDataEntity().getKeyPSDEField()>
        ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service.removeBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key) ;
                                        </#if>
                                    </#list>
                                </#if>
        repository.deleteById(key);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true ;
    }

    @Override
    public void removeBatch(Collection<${srfjavatype(keyfield.stdDataType)}> idList) {
        <@outputTestAction deaction "removeBatch"/>
        repository.deleteAll(repository.findAllById(idList));
    }

                    <#elseif deaction.getCodeName()?lower_case == "getdraft">
    @Override
    public ${item.getCodeName()} getDraft(${item.getCodeName()} et) {
        <@outputTestAction deaction "getdraft"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "checkkey">
    @Override
    public boolean checkKey(${item.getCodeName()} et) {
        <@outputTestAction deaction "checkkey"/>
        return repository.findById(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()).isPresent();
    }

                    <#else>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <@outputTestAction deaction "other"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    </#if>
    <#comment>输出测试实体行为</#comment>
    <@outputTestActionDetail deaction/>
                </#if>
            </#if>
        </#list>
    </#if>


    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
	@Override
    public List<${item.getCodeName()}> selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        ${item.getCodeName()}SearchContext context=new ${item.getCodeName()}SearchContext();
        context.setN_${MajorField.name?lower_case}_eq(${MajorkeyField.codeName?lower_case});
        Query query = new BasicQuery(context.getSelectCond().get().toString());
        return mongoTemplate.find(query,${item.getCodeName()}.class);
    }

    @Override
    public void removeBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        if(delIds.size()>0)
            this.removeBatch(delIds);
    }

	                                <#assign nested=MinorPSDER.isNestedRS()>
                                    <#if nested == false && MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                                        <#list MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                            <#if api.isNested()>
                                                <#assign nested=true>
                                            </#if>
                                        </#list>
                                    </#if>
                                    <#if nested>
                                    <@autowiredProxyService/>
	@Override
    public void saveBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case},List<${item.getCodeName()}> list) {
        if(list==null)
            return;
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        List<${item.getCodeName()}> _update=new ArrayList<${item.getCodeName()}>();
        List<${item.getCodeName()}> _create=new ArrayList<${item.getCodeName()}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        for(${item.getCodeName()} sub:list) {
            sub.set${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
            if(ObjectUtils.isEmpty(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}()))
                sub.set${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})sub.getDefaultKey(true));
            if(delIds.contains(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}())) {
                delIds.remove(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            proxyService.updateBatch(_update);
        if(_create.size()>0)
            proxyService.createBatch(_create);
        if(delIds.size()>0)
            proxyService.removeBatch(delIds);
	}

                                    </#if>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>
    

    @Resource
    protected MongoTemplate mongoTemplate;

    <#comment>输出数据查询</#comment>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
            <#if dedataset.getRender()??>
    ${dedataset.getRender().code}
            <#else>
    /**
     * 查询集合 ${dedataset.getLogicName()}
     */
    @Override
    public Page<${item.getCodeName()}> search${dedataset.getCodeName()}(${item.getCodeName()}SearchContext context) {
        Query query = new BasicQuery(context.getSelectCond().get().toString());
        long total = mongoTemplate.count(query, ${item.getCodeName()}.class);
        List<${item.getCodeName()}> list=mongoTemplate.find(query.with(context.getPageable()),${item.getCodeName()}.class);
        return new PageImpl<${item.getCodeName()}>(list,context.getPageable(),total);
    }

            </#if>
        </#list>
    </#if>

    <#if hasDEPrefield>
    @Override
    public List<${de.codeName}> get${deCodeNameCamel}ByIds(List<String> ids) {
        QueryBuilder permissionCond=new QueryBuilder();
        permissionCond.and("${keyfield.codeName?lower_case}").in(ids);
        Query query = new BasicQuery(permissionCond.get().toString());
        return mongoTemplate.find(query,${de.codeName}.class);
    }

    @Override
    public List<${de.codeName}> get${deCodeNameCamel}ByEntities(List<${de.codeName}> entities) {

        List ids =new ArrayList();
        for(${de.codeName} entity : entities){
            Serializable id=entity.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0){
            QueryBuilder permissionCond=new QueryBuilder();
            permissionCond.and("${keyfield.codeName?lower_case}").in(ids);
            Query query = new BasicQuery(permissionCond.get().toString());
            return mongoTemplate.find(query,${de.codeName}.class);
        }
        else
            return entities;
    }
    </#if>

    <#comment>实体数据导入</#comment>
    <@deImportData/>
}


<#comment>Api存储</#comment>
<#elseif de.getStorageMode()==4>
<#assign subSysServiceApiDECodeName=item.getPSSubSysServiceAPIDE().codeName>

import ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.client.${subSysServiceApiDECodeName}FeignClient;

/**
 * 实体[${item.getLogicName()}] 服务对象接口实现
 */
@Slf4j
@Service
public class ${item.getCodeName()}ServiceImpl implements I${de.getCodeName()}Service {

    <#comment>引入feignClient</#comment>
    @Autowired
    ${subSysServiceApiDECodeName}FeignClient ${subSysServiceApiDECodeName?uncap_first}FeignClient;

    <#assign keyfield=de.getKeyPSDEField()>

    <#comment>引入关联依赖</#comment>
    <#if de.getMajorPSDERs()??>
        <#list de.getMajorPSDERs() as der>
            <#if der.getDERType() =='DER1N' && (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2)>
                <#if !P.exists('DEMinorPSDataEntity',der.getMinorPSDataEntity().getCodeName())>
    @Autowired
    @Lazy
    protected ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                </#if>
            </#if>
        </#list>
    </#if>

    <#comment>输出实体行为</#comment>
    <#if item.getAllPSDEActions()??>
        <#list item.getAllPSDEActions() as deaction>
            <#if deaction.isEnableBackend()>
                <#if deaction.getRender()??>
    ${deaction.getRender().code}
                <#else>
                    <#if (deaction.getActionType()=='USERCUSTOM')>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <@outputTestAction deaction "usercustom"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //自定义代码
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getActionType()=='DELOGIC'>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
         <@outputTestAction deaction "delogic"/>
         <#comment>附加数据逻辑-操作前</#comment>
         <@addBoforeLogic deaction/>
         ${deaction.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
         <#comment>附加数据逻辑-操作后</#comment>
         <@addAfterLogic deaction/>
         return et ;
    }

                    <#elseif deaction.getCodeName()?lower_case == 'get'>
    @Override
    public ${item.getCodeName()} get(${srfjavatype(keyfield.stdDataType)} ${keyfield.getCodeName()?lower_case}) {
                    <@outputTestAction deaction "get"/>
                    <#if item.isEnableAPIStorage()>
                        <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
                            <#--<#comment>附加数据逻辑-操作前</#comment>-->
                            <#--<@buildEntityParam deaction/>-->
                            <#--<@addGetActionBoforeLogic deaction/>-->
		${item.getCodeName()} et=${subSysServiceApiDECodeName?uncap_first}FeignClient.${deaction.getPSSubSysServiceAPIDEMethod().getCodeName()?uncap_first}(${keyfield.getCodeName()?lower_case});
        if(et==null){
            et=new ${item.getCodeName()}();
            et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(${keyfield.getCodeName()?lower_case});
        }
        else{
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
            et.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.selectBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key));
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        }
        <#--<#comment>附加数据逻辑-操作后</#comment>-->
        <#--<@addAfterLogic deaction/>-->
        return  et;
                        <#else>
        return null;
                        </#if>
                    </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "createbatch">
                    <#elseif deaction.getCodeName()?lower_case == "updatebatch">
                    <#elseif deaction.getCodeName()?lower_case == "removebatch">
                    <#elseif deaction.getCodeName()?lower_case == "savebatch">
                    <#elseif deaction.getCodeName()?lower_case == "create">
    @Override
    public boolean create(${item.getCodeName()} et) {
                        <@outputTestAction deaction "create"/>
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
                                <#comment>附加数据逻辑-操作前</#comment>
                                <@addBoforeLogic deaction/>
        ${item.getCodeName()} rt = ${subSysServiceApiDECodeName?uncap_first}FeignClient.create(et);
        if(rt==null)
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(rt.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
        rt.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        CachedBeanCopier.copy(rt,et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>
    }

    public void createBatch(List<${item.codeName}> list){
        <@outputTestAction deaction "createBatch"/>
                    <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        ${subSysServiceApiDECodeName?uncap_first}FeignClient.createBatch(list) ;
                            </#if>
                    </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "update">
    @Override
    public boolean update(${item.getCodeName()} et) {
                        <@outputTestAction deaction "update"/>
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
                                <#comment>附加数据逻辑-操作前</#comment>
                                <@addBoforeLogic deaction/>
        ${item.getCodeName()} rt = ${subSysServiceApiDECodeName?uncap_first}FeignClient.update(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et);
        if(rt==null)
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}()));
        rt.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        CachedBeanCopier.copy(rt,et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>

    }

    public void updateBatch(List<${item.codeName}> list){
        <@outputTestAction deaction "updateBatch"/>
                    <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        ${subSysServiceApiDECodeName?uncap_first}FeignClient.updateBatch(list) ;
                            </#if>
                    </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "save">
    @Override
    <@transactionalAnno deaction/>
    public boolean save(${item.getCodeName()} et) {
                        <@outputTestAction deaction "save"/>
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
                                <#comment>附加数据逻辑-操作前</#comment>
                                <@addBoforeLogic deaction/>
        if(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()==null) et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})et.getDefaultKey(true));
        if(!${subSysServiceApiDECodeName?uncap_first}FeignClient.save(et))
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
        rt.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>
    }

    @Override
    public void saveBatch(List<${item.getCodeName()}> list) {
                        <@outputTestAction deaction "saveBatch"/>
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        ${subSysServiceApiDECodeName?uncap_first}FeignClient.saveBatch(list) ;
                            </#if>
                        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "remove">
    @Override
    public boolean remove(${srfjavatype(keyfield.stdDataType)} ${keyfield.getCodeName()?lower_case}) {
        <@outputTestAction deaction "remove"/>
                                <#if de.getMajorPSDERs()??>
                                    <#list de.getMajorPSDERs() as der>
                                        <#if der.getDERType() =='DER1N' && der.isNestedRS() && der.getMinorPSDataEntity()?? &&  (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2) >
                                        <#assign MajorDerField = der.getPSPickupDEField()>
                                        <#assign minorKeyField = der.getMinorPSDataEntity().getKeyPSDEField()>
        ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service.removeBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key) ;
                                        </#if>
                                    </#list>
                                </#if>
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        <#--<#comment>附加数据逻辑-操作前</#comment>-->
        <#--<@buildEntityParam deaction/>-->
        <#--<@addBoforeLogic deaction/>-->
        boolean result=${subSysServiceApiDECodeName?uncap_first}FeignClient.remove(${keyfield.getCodeName()?lower_case}) ;
        <#--<#comment>附加数据逻辑-操作后</#comment>-->
        <#--<@addAfterLogic deaction/>-->
        return result;
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>
    }

    public void removeBatch(Collection<${srfjavatype(keyfield.stdDataType)}> idList){
                        <@outputTestAction deaction "removeBatch"/>
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        ${subSysServiceApiDECodeName?uncap_first}FeignClient.removeBatch(idList);
                            </#if>
                        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "getdraft">
    @Override
    public ${item.getCodeName()} getDraft(${item.getCodeName()} et) {
                        <@outputTestAction deaction "getdraft"/>
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        et=${subSysServiceApiDECodeName?uncap_first}FeignClient.getDraft();
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
                            <#else>
        return null;
                            </#if>
                        <#else>
        return null;
                        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "checkkey">
    @Override
    public boolean checkKey(${item.getCodeName()} et) {
                        <@outputTestAction deaction "checkkey"/>
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        return ${subSysServiceApiDECodeName?uncap_first}FeignClient.checkKey(et);
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>
    }
                    <#else>
    @Override
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
                <@outputTestAction deaction "other"/>
                <#if item.isEnableAPIStorage()>
                    <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
         <#comment>附加数据逻辑-操作前</#comment>
         <@addBoforeLogic deaction/>
         et=${subSysServiceApiDECodeName?uncap_first}FeignClient.${deaction.getPSSubSysServiceAPIDEMethod().getCodeName()?uncap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et);
         <#comment>附加数据逻辑-操作后</#comment>
         <@addAfterLogic deaction/>
         return et;
                    <#else>
         return null;
                    </#if>
                <#else>
         return null;
                </#if>
    }
                    </#if>
    <#comment>输出测试实体行为</#comment>
    <@outputTestActionDetail deaction/>
                </#if>
            </#if>
        </#list>
    </#if>


    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
	@Override
    public List<${item.getCodeName()}> selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        ${item.getCodeName()}SearchContext context=new ${item.getCodeName()}SearchContext();
        context.setSize(Integer.MAX_VALUE);
        context.setN_${MajorField.name?lower_case}_eq(${MajorkeyField.codeName?lower_case});
        return ${subSysServiceApiDECodeName?uncap_first}FeignClient.search${deDefaultDataSet.getCodeName()}(context).getContent();
    }

    @Override
    public void removeBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        if(delIds.size()>0)
            this.removeBatch(delIds);
    }

	                                <#assign nested=MinorPSDER.isNestedRS()>
                                    <#if nested == false && MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                                        <#list MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                            <#if api.isNested()>
                                                <#assign nested=true>
                                            </#if>
                                        </#list>
                                    </#if>
                                    <#if nested>
                                    <@autowiredProxyService/>
	@Override
    public void saveBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case},List<${item.getCodeName()}> list) {
        if(list==null)
            return;
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        List<${item.getCodeName()}> _update=new ArrayList<${item.getCodeName()}>();
        List<${item.getCodeName()}> _create=new ArrayList<${item.getCodeName()}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        for(${item.getCodeName()} sub:list) {
            sub.set${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
            if(ObjectUtils.isEmpty(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}()))
                sub.set${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})sub.getDefaultKey(true));
            if(delIds.contains(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}())) {
                delIds.remove(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            proxyService.updateBatch(_update);
        if(_create.size()>0)
            proxyService.createBatch(_create);
        if(delIds.size()>0)
            proxyService.removeBatch(delIds);
	}

                                    </#if>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>


    <#comment>输出数据查询</#comment>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
            <#if dedataset.getRender()??>
    ${dedataset.getRender().code}
            <#else>
                <#if  dedataset.getPSSubSysServiceAPIDEMethod()??>
                    <#assign sysServiceApiMethod=dedataset.getPSSubSysServiceAPIDEMethod().getCodeName()?uncap_first?replace("fetch","search")>
                <#else>
                    <#assign sysServiceApiMethod="search"+dedataset.getCodeName()>
                </#if>
    /**
     * 查询集合 ${dedataset.getLogicName()}
     */
    @Override
    public Page<${item.getCodeName()}> search${dedataset.getCodeName()}(${item.getCodeName()}SearchContext context) {
        <#--<#if item.isEnableNoSQLStorage() && item.getAllPSDEDBTables()??>-->
        <#--<#list item.getAllPSDEDBTables() as detable>-->
        Page<${de.getCodeName()}> ${de.getCodeName()?uncap_first}s=${subSysServiceApiDECodeName?uncap_first}FeignClient.${sysServiceApiMethod}(context);
        return ${de.getCodeName()?uncap_first}s;
        <#--</#list>-->
        <#--<#else>-->
        <#--return null ;-->
        <#--</#if>-->
    }

            </#if>
        </#list>
    </#if>

    <#comment>实体数据导入</#comment>
    <@deImportData/>

}

<#comment>无存储</#comment>
<#elseif de.getStorageMode()==0>

/**
 * 实体[${item.getLogicName()}] 无存储服务对象接口实现
 */
@Slf4j
@Service
public class ${item.getCodeName()}ServiceImpl implements I${de.getCodeName()}Service {

    <#assign keyfield=de.getKeyPSDEField()>

    <#comment>引入关联依赖</#comment>
    <#if de.getMajorPSDERs()??>
        <#list de.getMajorPSDERs() as der>
            <#if der.getDERType() =='DER1N' >
                <#if !P.exists('DEMinorPSDataEntity',der.getMinorPSDataEntity().getCodeName())>
    @Autowired
    @Lazy
    protected ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                </#if>
            </#if>
        </#list>
    </#if>
    <#comment>引入处理逻辑</#comment>
    <#if de.getAllPSDEActions()??>
        <#list de.getAllPSDEActions() as deAction>
            <#comment>实体行为调用处理逻辑</#comment>
            <#if deAction.getActionType() =='DELOGIC' >
            <#assign deLogic=deAction.getPSDELogic()>
                <@importDELogic deLogic />
            </#if>
            <#comment>实体行为附加逻辑</#comment>
            <#if deAction.getPSDEActionLogics()??>
                <#list deAction.getPSDEActionLogics() as deActionLogic>
                    <#if deActionLogic.isInternalLogic()>
                    <#assign deLogic=deActionLogic.getPSDELogic()>
                    <@importDELogic deLogic />
                    </#if>
                </#list>
            </#if>
        </#list>
    </#if>

    <#comment>输出实体行为</#comment>
    <#if item.getAllPSDEActions()??>
        <#list item.getAllPSDEActions() as deaction>
            <#if deaction.isEnableBackend()>
                <#if deaction.getRender()??>
    ${deaction.getRender().code}
                <#else>
                    <#if (deaction.getActionType()=='USERCUSTOM')>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <@outputTestAction deaction "usercustom"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //自定义代码
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getActionType()=='DELOGIC'>
    @Override
    <@transactionalAnno deaction/>
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <@outputTestAction deaction "delogic"/>
         <#comment>附加数据逻辑-操作前</#comment>
         <@addBoforeLogic deaction/>
         ${deaction.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
         <#comment>附加数据逻辑-操作后</#comment>
         <@addAfterLogic deaction/>
         return et ;
    }

                    <#elseif deaction.getCodeName()?lower_case == 'get'>
    @Override
    public ${item.getCodeName()} get(${srfjavatype(keyfield.stdDataType)} key) {
        <@outputTestAction deaction "get"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@buildEntityParam deaction/>
        <@addGetActionBoforeLogic deaction/>
        ${item.getCodeName()} et = new ${item.getCodeName()}();
        et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(key);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "createbatch">
                    <#elseif deaction.getCodeName()?lower_case == "updatebatch">
                    <#elseif deaction.getCodeName()?lower_case == "removebatch">
                    <#elseif deaction.getCodeName()?lower_case == "savebatch">
                    <#elseif deaction.getCodeName()?lower_case == "create">
    @Override
    public boolean create(${item.getCodeName()} et) {
        <@outputTestAction deaction "create"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //代码实现
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    public void createBatch(List<${item.codeName}> list){
        <@outputTestAction deaction "createBatch"/>
    }

                    <#elseif deaction.getCodeName()?lower_case == "update">
    @Override
    public boolean update(${item.getCodeName()} et) {
        <@outputTestAction deaction "update"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //代码实现
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    public void updateBatch(List<${item.codeName}> list){
        <@outputTestAction deaction "updateBatch"/>
    }

                    <#elseif deaction.getCodeName()?lower_case == "save">
    @Override
    <@transactionalAnno deaction/>
    public boolean save(${item.getCodeName()} et) {
        <@outputTestAction deaction "save"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //代码实现
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    @Override
    public void saveBatch(List<${item.getCodeName()}> list) {
        <@outputTestAction deaction "saveBatch"/>
    }

                    <#elseif deaction.getCodeName()?lower_case == "remove">
    @Override
    public boolean remove(${srfjavatype(keyfield.stdDataType)} key) {
        <@outputTestAction deaction "remove"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@buildEntityParam deaction/>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    public void removeBatch(Collection<${srfjavatype(keyfield.stdDataType)}> idList){
        <@outputTestAction deaction "removeBatch"/>
    }

                    <#elseif deaction.getCodeName()?lower_case == "getdraft">
    @Override
    public ${item.getCodeName()} getDraft(${item.getCodeName()} et) {
        <@outputTestAction deaction "getdraft"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "checkkey">
    @Override
    public boolean checkKey(${item.getCodeName()} et) {
        <@outputTestAction deaction "checkkey"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return false;
    }
                    <#else>
    @Override
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <@outputTestAction deaction "other"/>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }
                    </#if>
    <#comment>输出测试实体行为</#comment>
    <@outputTestActionDetail deaction/>
                </#if>
            </#if>
        </#list>
    </#if>


    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
	@Override
    public List<${item.getCodeName()}> selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        return null;
    }

    @Override
    public void removeBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        if(delIds.size()>0)
            this.removeBatch(delIds);
    }

	                                <#assign nested=MinorPSDER.isNestedRS()>
                                    <#if nested == false && MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                                        <#list MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                            <#if api.isNested()>
                                                <#assign nested=true>
                                            </#if>
                                        </#list>
                                    </#if>
                                    <#if nested>
                                    <@autowiredProxyService/>
	@Override
    public void saveBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case},List<${item.getCodeName()}> list) {
        if(list==null)
            return;
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        List<${item.getCodeName()}> _update=new ArrayList<${item.getCodeName()}>();
        List<${item.getCodeName()}> _create=new ArrayList<${item.getCodeName()}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        for(${item.getCodeName()} sub:list) {
            sub.set${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
            if(ObjectUtils.isEmpty(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}()))
                sub.set${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})sub.getDefaultKey(true));
            if(delIds.contains(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}())) {
                delIds.remove(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            proxyService.updateBatch(_update);
        if(_create.size()>0)
            proxyService.createBatch(_create);
        if(delIds.size()>0)
            proxyService.removeBatch(delIds);
	}

                                    </#if>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>


    <#comment>输出数据查询</#comment>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
            <#if dedataset.getRender()??>
    ${dedataset.getRender().code}
            <#else>
    /**
     * 查询集合 ${dedataset.getLogicName()}
     */
    @Override
    public Page<${item.getCodeName()}> search${dedataset.getCodeName()}(${item.getCodeName()}SearchContext context) {
        <#--<#if item.isEnableNoSQLStorage() && item.getAllPSDEDBTables()??>-->
        <#--<#list item.getAllPSDEDBTables() as detable>-->
        return new PageImpl<${item.getCodeName()}>(new ArrayList(),context.getPageable(),0);
        <#--</#list>-->
        <#--<#else>-->
        <#--return null ;-->
        <#--</#if>-->
    }

        </#if>
        </#list>
    </#if>

    <#comment>实体数据导入</#comment>
    <@deImportData/>
}
</#if>

<#macro buildEntityParam deaction>
    <#comment>由于get跟remove参数为key，构造entity以便传入逻辑中</#comment>
    <#assign tempEntityName="et">
    <#if deaction.getPSDEActionLogics()??>
        <#list deaction.getPSDEActionLogics() as actionlogic>
            <#if actionlogic.isValid()==true>
                <#if deaction.getCodeName()?lower_case == "get">
                    <#assign tempEntityName="tempET">
                </#if>
        ${de.codeName} ${tempEntityName}=new ${de.codeName}();
                <#if keyfield??>
        ${tempEntityName}.set("${keyfield.codeName?lower_case}",key);
                </#if>
                <#break>
            </#if>
        </#list>
    </#if>
</#macro>

<#comment>Get行为附加逻辑-操作前</#comment>
<#macro addGetActionBoforeLogic deaction>
    <#if deaction.getPSDEActionLogics()??>
        <#list deaction.getPSDEActionLogics() as actionlogic>
            <#if actionlogic.getAttachMode()=='BEFORE' && actionlogic.isValid()==true>
                <#if actionlogic.isInternalLogic()>
        ${actionlogic.getPSDELogic().getCodeName()?lower_case}Logic.execute(tempET);
                </#if>
            </#if>
        </#list>
    </#if>
</#macro>

<#comment>附加逻辑-操作前</#comment>
<#macro addBoforeLogic deaction>
    <#if deaction.getPSDEActionLogics()??>
        <#list deaction.getPSDEActionLogics() as actionlogic>
            <#if actionlogic.getAttachMode()=='BEFORE' && actionlogic.isValid()==true>
                <#if actionlogic.isInternalLogic() && actionlogic.getPSDELogic().isEnableBackend()>
        ${actionlogic.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
                </#if>
            </#if>
        </#list>
    </#if>
</#macro>

<#comment>附加逻辑-操作后</#comment>
<#macro addAfterLogic deaction>
    <#if deaction.getPSDEActionLogics()??>
        <#list deaction.getPSDEActionLogics() as actionlogic>
            <#if actionlogic.getAttachMode()=='AFTER' && actionlogic.isValid()==true>
                <#if actionlogic.isInternalLogic() && actionlogic.getPSDELogic().isEnableBackend()>
        ${actionlogic.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
                </#if>
            </#if>
        </#list>
    </#if>
</#macro>
<#macro importDELogic deLogic>
    <#if !P.exists('DELOGIC',deLogic.getCodeName())>

    @Autowired
    @Lazy
    protected ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.service.logic.I${de.getCodeName()}${deLogic.codeName}Logic ${deLogic.getCodeName()?lower_case}Logic;
    </#if>
</#macro>

<#comment>实体行为参数</#comment>
<#macro addDEActionParam deaction>
<#if deaction.getParamMode?? && deaction.getParamMode()?? && deaction.getPSDEActionParams()??>
    <#assign hasDEActionParam=false>
    <#list deaction.getPSDEActionParams() as actionParam>
        <#assign hasDEActionParam=true>
        <#assign  actionParamValue="null">
        <#assign targetFieldName="null">
        <#if actionParam.getValueType()=='SESSION' || actionParam.getValueType()=='PARAM'|| actionParam.getValueType()=='CONTEXT'>
            <#assign targetFieldName=actionParam.getValue()>
            <#if de.getPSDEField(targetFieldName,true)??>
                <#assign targetFieldName=srfcaseformat(de.getPSDEField(targetFieldName,true).getCodeName(),'l_u2lC')>
            </#if>
        </#if>
        <#assign actionParamFieldCodeName=actionParam.getPSDEField().codeName>
        <#if actionParam.getValueType()=='VALUE'><#comment>指定值</#comment>
            <#assign  actionParamValue="\""+actionParam.getValue()+"\"">
        <#elseif actionParam.getValueType()=='PARAM'><#comment>数据对象属性</#comment>
            <#assign actionParamValue="et.get(\""+targetFieldName?lower_case+"\")">
        <#elseif actionParam.getValueType()=='NULLVALUE'><#comment>空值</#comment>
        <#elseif actionParam.getValueType()=='SESSION'><#comment>用户全局对象</#comment>
            <#assign actionParamValue=pub.getPKGCodeName()+".util.security.AuthenticationUser.getAuthenticationUser().getSessionParams().get(\""+targetFieldName?lower_case+"\")">
        <#elseif actionParam.getValueType()=='APPLICATION'><#comment>系统全局对象</#comment>
        <#elseif actionParam.getValueType()=='UNIQUEID'><#comment>唯一编码</#comment>
            <#assign actionParamValue="et.getDefaultKey(true)">
        <#elseif actionParam.getValueType()=='CONTEXT'><#comment>网页请求</#comment>
            <#assign actionParamValue="et.getExtensionparams().get(\""+targetFieldName?lower_case+"\")">
        <#elseif actionParam.getValueType()=='OPERATOR'><#comment>当前操作用户(编号)</#comment>
            <#assign actionParamValue=pub.getPKGCodeName()+".util.security.AuthenticationUser.getAuthenticationUser().getUserid()">
        <#elseif actionParam.getValueType()=='OPERATORNAME'><#comment>当前操作用户(名称)</#comment>
            <#assign actionParamValue=pub.getPKGCodeName()+".util.security.AuthenticationUser.getAuthenticationUser().getPersonname()">
        <#elseif actionParam.getValueType()=='CURTIME'><#comment>当前时间</#comment>
            <#assign actionParamValue="new java.sql.Timestamp(new java.util.Date().getTime())">
        <#elseif actionParam.getValueType()=='APPDATA'><#comment>当前应用数据</#comment>
        </#if>
        <#if actionParam.getPSDEField().isKeyDEField()==true && actionParamValue=='null'>
        <#else>
        et.set("${actionParamFieldCodeName}",${actionParamValue});
        </#if>
    </#list>
    <#if hasDEActionParam>
        <#if deaction.getActionType()== "USERCREATE">
        create(et);
        <#elseif deaction.getActionType()== "USERUPDATE">
        update(et);
        </#if>
    </#if>
</#if>
</#macro>

<#comment>输出测试行为</#comment>
<#macro outputTestAction deaction actionParam>
    <#if deaction.isEnableBackend() && deaction.getTestActionMode?? && deaction.getTestActionMode()??>
    <#if deaction.getTestActionMode() ==1 || deaction.getTestActionMode() ==3  >
        <#if (deaction.getActionType()=='USERCUSTOM')>
        test${srfmethodname(deaction.getCodeName())?cap_first}(et);
        <#elseif deaction.getActionType()=='DELOGIC'>
        test${srfmethodname(deaction.getCodeName())?cap_first}(et);
        <#elseif deaction.getCodeName()?lower_case == 'get'>
        testGet(key);
        <#elseif deaction.getCodeName()?lower_case == "createbatch">
        <#elseif deaction.getCodeName()?lower_case == "updatebatch">
        <#elseif deaction.getCodeName()?lower_case == "removebatch">
        <#elseif deaction.getCodeName()?lower_case == "savebatch">
        <#elseif deaction.getCodeName()?lower_case == "create">
            <#if actionParam=='createBatch'>
        testCreateBatch(list);
            <#else>
        testCreate(et);
            </#if>
        <#elseif deaction.getCodeName()?lower_case == "update">
            <#if actionParam=='updateBatch'>
        testUpdateBatch(list);
            <#else>
        testUpdate(et);
            </#if>
        <#elseif deaction.getCodeName()?lower_case == "save">
            <#if actionParam=='saveBatch'>
        testSaveBatch(list);
            <#elseif actionParam=='saveOrUpdate'>
        testSaveOrUpdate(et);
            <#else>
        testSave(et);
            </#if>
        <#elseif deaction.getCodeName()?lower_case == "remove">
            <#if actionParam=='removeBatch'>
        testRemoveBatch(idList);
            <#else>
        testRemove(key);
            </#if>
        <#elseif deaction.getCodeName()?lower_case == "getdraft">
        testGetDraft(et);
        <#elseif deaction.getCodeName()?lower_case == "checkkey">
        testCheckKey(et);
        <#else>
        test${srfmethodname(deaction.getCodeName())?cap_first}(et);
        </#if>
    </#if>
    </#if>
</#macro>

<#comment>输出测试行为</#comment>
<#macro outputTestActionDetail deaction>
    <#if deaction.isEnableBackend() && deaction.getTestActionMode?? && deaction.getTestActionMode()??>
        <#if deaction.getTestActionMode() ==1 || deaction.getTestActionMode() ==3>
        <#if (deaction.getActionType()=='USERCUSTOM')>
    public boolean test${srfmethodname(deaction.getCodeName())?cap_first}(${item.getCodeName()} et) {
        return true;
    }

        <#elseif deaction.getActionType()=='DELOGIC'>
    public boolean test${srfmethodname(deaction.getCodeName())?cap_first}(${item.getCodeName()} et) {
        return true;
    }

        <#elseif deaction.getCodeName()?lower_case == 'get'>
    public boolean testGet(${srfjavatype(keyfield.stdDataType)} key) {
        return true;
    }

        <#elseif deaction.getCodeName()?lower_case == "createbatch">
        <#elseif deaction.getCodeName()?lower_case == "updatebatch">
        <#elseif deaction.getCodeName()?lower_case == "removebatch">
        <#elseif deaction.getCodeName()?lower_case == "savebatch">
        <#elseif deaction.getCodeName()?lower_case == "create">
    public boolean testCreate(${item.getCodeName()} et) {
        return true;
    }

    public boolean testCreateBatch(List<${item.getCodeName()}> list) {
        return true;
    }

        <#elseif deaction.getCodeName()?lower_case == "update">
    public boolean testUpdate(${item.getCodeName()} et) {
        return true;
    }

    public boolean testUpdateBatch(List<${item.getCodeName()}> list) {
        return true;
    }

        <#elseif deaction.getCodeName()?lower_case == "save">
    public boolean testSave(${item.getCodeName()} et) {
        return true;
    }

    public boolean testSaveOrUpdate(${item.getCodeName()} et) {
        return true;
    }

    public boolean testSaveBatch(Collection<${item.getCodeName()}> list) {
        return true;
    }

    public boolean testSaveBatch(List<${item.getCodeName()}> list) {
        return true;
    }

        <#elseif deaction.getCodeName()?lower_case == "remove">
    public boolean testRemove(${srfjavatype(keyfield.stdDataType)} key) {
        return true;
    }

    public boolean testRemoveBatch(Collection<${srfjavatype(keyfield.stdDataType)}> idList) {
        return true;
    }

        <#elseif deaction.getCodeName()?lower_case == "getdraft">
    public boolean testGetDraft(${item.getCodeName()} et) {
        return true;
    }

        <#elseif deaction.getCodeName()?lower_case == "checkkey">
    public boolean testCheckKey(${item.getCodeName()} et) {
        return true;
    }

        <#else>
    public boolean test${srfmethodname(deaction.getCodeName())?cap_first}(${item.getCodeName()} et) {
        return true;
    }

        </#if>
    </#if>
    </#if>
</#macro>

<#comment>注入代理行为</#comment>
<#macro autowiredProxyService>
    <#if !P.exists(de.codeName,'proxyService')>
    @Autowired
    @Lazy
    I${de.codeName}Service proxyService;
    </#if>
</#macro>

<#comment>实体数据导入</#comment>
<#macro deImportData>
    <#if hasDEImport>
        <@autowiredProxyService/>

    @Value("${r'${ibiz.syncImportLimit:1000}'}")
    private int syncImportLimit;

    /**
     * 上传数据检查
     * @param entities
     * @param isIgnoreError
     * @return
     */
    private JSONObject testImportData(List<${de.codeName}> entities,boolean isIgnoreError) {

        JSONObject rs=new JSONObject();
        Set ids=new HashSet<>();
        List<String> errorMsgs = new ArrayList<>();
        List<Integer> errorLines = new ArrayList<>();
        List<${de.codeName}> duplicateKeys=new ArrayList<>();
        String keyField= DEFieldCacheMap.getDEKeyField(${de.codeName}.class);
        if(ObjectUtils.isEmpty(keyField)){
            errorLines.add(1);
            rs.put("rst", 1);
            rs.put("msg", "数据导入失败，未能获取到实体[${de.codeName}]的主键属性");
            rs.put("errorLines", errorLines);
            return rs;
        }
        //主键重复性判断.外键约束判断（上传数据自身的检查/数据库的检查）
        for(int i=0;i<entities.size();i++) {
            ${de.codeName} entity = entities.get(i);
            Object id = entity.get(keyField);
            if(ObjectUtils.isEmpty(id)) {
                id = entity.getDefaultKey(true);
                entity.set(keyField, id);
            }
            if(!ids.contains(id)){
                ids.add(id);
            }
            else{
                Integer lineNum = i + 1;
                errorLines.add(lineNum);
                errorMsgs.add("第" + lineNum + "行：导入数据之间存在重复数据。");
                if(isIgnoreError){
                    duplicateKeys.add(entity);
                    continue;
                }
                else{
                    break;
                }
            }
        <#if de.getMajorPSDER1Ns?? && de.getMajorPSDER1Ns()??>
            <#list de.getMinorPSDERs() as MinorPSDER>
                <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N' && (MinorPSDER.getMajorPSDataEntity().getStorageMode()==1||MinorPSDER.getMajorPSDataEntity().getStorageMode()==2||MinorPSDER.getMajorPSDataEntity().getStorageMode()==4)>
                    <#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
                        <#assign MajorKeyFieldCodeName =srfcaseformat(MinorPSDER.getPSPickupDEField().codeName,'l_u2lC')?cap_first>
                        <#assign MajorEntity=MinorPSDER.getMajorPSDataEntity()>
                        <#assign MajorEntityCodeName=MinorPSDER.getMajorPSDataEntity().codeName>
                        <#assign MajorEntityService=srfcaseformat(MinorPSDER.getMajorPSDataEntity().getCodeName(),'l_u2lC')+"Service">
        //实体关系[${MinorPSDER.name}]
        if(!ObjectUtils.isEmpty(entity.get${MajorKeyFieldCodeName}())){
            ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntityCodeName} fkEntity=${MajorEntityService}.getById(entity.get${MajorKeyFieldCodeName}());
            if(ObjectUtils.isEmpty(fkEntity)){
                Integer lineNum = i + 1;
                errorLines.add(lineNum);
                errorMsgs.add(String.format("第" + lineNum + "行：[%s]父数据有误。",entity.get${MajorKeyFieldCodeName}()));
                if(isIgnoreError){
                    entity.set${MajorKeyFieldCodeName}(null);
                    continue;
                }
                else{
                   break;
                }
            }
        }
                    </#if>
                </#if>
            </#list>
        </#if>
        }
        if(duplicateKeys.size()>0){
            for(${de.codeName} duplicateKey:duplicateKeys){
                entities.remove(duplicateKey);
            }
        }
        if (errorMsgs.size() > 0) {
            rs.put("rst", 1);
            rs.put("msg", String.join("<br>", errorMsgs));
            rs.put("errorLines", errorLines);
            return rs;
        }
        rs.put("rst", 0);
        return rs;
    }

    /**
     * 实体数据导入
     * @param entities
     * @param batchSize
     * @param isIgnoreError
     * @return
     */
    @Override
    @Transactional
    public JSONObject importData(List<${de.codeName}> entities, int batchSize ,boolean isIgnoreError) {
        if(entities.size()>syncImportLimit){
            proxyService.asyncImportData(entities,batchSize,isIgnoreError);
            JSONObject rs=new JSONObject();
            rs.put("rst", 0);
            rs.put("msg",String.format("当前导入数据已超过同步导入数量上限[%s]，系统正在进行异步导入，请稍后!",syncImportLimit));
            rs.put("data",entities);
            return rs;
        }
        else{
            return syncImportData(entities,batchSize,isIgnoreError);
        }
    }

    @Transactional
    public void asyncImportData(List<${de.codeName}> entities, int batchSize ,boolean isIgnoreError){
        executeImportData(entities,batchSize,isIgnoreError);
    }

    @Transactional
    public JSONObject syncImportData(List<${de.codeName}> entities, int batchSize ,boolean isIgnoreError){
        return executeImportData(entities,batchSize,isIgnoreError);
    }

    @Transactional
    public JSONObject executeImportData(List<${de.codeName}> entities, int batchSize ,boolean isIgnoreError) {

        JSONObject rs=testImportData(entities,isIgnoreError);
        if(rs.getInteger("rst")==1 && !isIgnoreError)
            return rs;

        String keyField= DEFieldCacheMap.getDEKeyField(${de.codeName}.class);
        List<${de.codeName}> tempDEList=new ArrayList<>();
        Set tempIds=new HashSet<>();

        for(int i=0;i<entities.size();i++) {
            ${de.codeName} entity = entities.get(i);
            tempDEList.add(entity);
            Object id=entity.get(keyField);
            if(!ObjectUtils.isEmpty(id))
                tempIds.add(id);
            if(tempDEList.size()>=batchSize || (tempDEList.size()<batchSize && i==entities.size()-1)){
                commit(tempDEList,tempIds);
                tempDEList.clear();
                tempIds.clear();
                }
            }
        rs.put("rst", 0);
        rs.put("data",entities);
        return rs;
    }

    /**
     * 批量提交
     * @param entities 数据
     * @param ids 要提交数据的id
     */
    @Transactional
    public void commit(List<${de.codeName}> entities, Set ids){

        String keyField= DEFieldCacheMap.getDEKeyField(${de.codeName}.class);
        List<${de.codeName}> _create=new ArrayList<>();
        List<${de.codeName}> _update=new ArrayList<>();
        Set oldIds=new HashSet<>();
        if(ids.size()>0){
            List<${de.codeName}> oldEntities=this.listByIds(ids);
            for(${de.codeName} entity:oldEntities){
                oldIds.add(entity.get(keyField));
            }
        }
        for(${de.codeName} entity:entities){
            Object id=entity.get(keyField);
            if(oldIds.contains(id))
                _update.add(entity);
            else
                _create.add(entity);
        }
        if(_update.size()>0)
            proxyService.updateBatch(_update);
        if(_create.size()>0)
            proxyService.createBatch(_create);
    }
    </#if>
</#macro>

<#comment>事务注解</#comment>
<#macro transactionalAnno deaction>
    <#if deaction.getTransactionMode?? && deaction.getTransactionMode()??>
        <#if deaction.getTransactionMode()=='GLOBAL'>
    @GlobalTransactional
        <#elseif deaction.getTransactionMode()=='DEFAULT'>
    @Transactional
        </#if>
    </#if>
</#macro>

</#if>
